#include <iostream>
#include <string>
#include "move.h"
#include "movegen.h"
#include "make.h"
#include "squares.h"
#include "piece.h"
#include "attack.h"

using namespace std;

bool flaggood(uint flag)
{
     if(flag!=FlagE && flag != FlagCA && flag != FlagEP) return false;

     return true;
}

bool moveiscastle(uint side, cBoard &board, uint move)
{
    uint from = FROM(move);
    uint to = TO(move);
    uint piece = board.getpiece(from);

    ASS(onbrd(from));
    ASS(onbrd(to));
    ASS(piecegood(piece));
    ASS(side==cW||side==cB);

    if(side==cW && piece==pwK && from ==E1)
    {
        if(to==G1 || to==C1) return true;
    }
    else if(side==cB && piece==pbK && from ==E8)
     {
        if(to==G8 || to==C8) return true;
    }

    return false;
}

bool moveiscapture(uint move)
{
    if(CAP(move)!=0) return true;
    if(FLAG(move)==FlagEP) return true;

    return false;
}

void printmovelong(uint move)
{
       uint from = FROM(move);
       uint to = TO(move);
       uint cap = CAP(move);
       uint prom = PROM(move);

       ASS(onbrd(from));
       ASS(onbrd(to));
       ASS(piecegood(cap));
       ASS(piecegood(prom));
	   cout<<"->"<<printsquare(from)<<"->"<<printsquare(to)<<" captured: ["<<piecechar(cap)<<"] promoted to: ["<<piecechar(prom)<<"]";
}

string printmove(uint move)
{
       uint from = FROM(move);
       uint to = TO(move);
       uint prom = PROM(move);

       ASS(onbrd(from));
       ASS(onbrd(to));
       ASS(piecegood(prom));

	   string m;

	   m+=printsquare(from);
	   m+=printsquare(to);

       //printf("%s%s",printsquare(from),printsquare(to));

       if(prom)
       {
         switch (prom)
         {
          case pwQ :m+='q'; break;
          case pwR :m+='r'; break;
          case pwB :m+='b'; break;
          case pwN :m+='n'; break;
          case pbQ :m+='q'; break;
          case pbR :m+='r'; break;
          case pbB :m+='b'; break;
          case pbN :m+='n'; break;
          default: cout<<"\n prom piece print error"; exit(1);
          break;
         };
       }
	   return m;
}


string movetosan(uint move, cBoard &pboard, cMaterial &mat, /*cMovelist &mlist,*/ cHistory &his)
{
    uint *board = pboard.p2board();
    uint from = FROM(move);
    uint to = TO(move);
    uint fromfile = files[from];
    uint tofile = files[to];
    uint fromrank = ranks[from];
    uint torank = ranks[to];
    uint piecefrom = board[from];
    bool ambiguous = false;
    uint ambigsq[8] = {0,0,0,0,0,0,0,0};
    uint ambignum = 0;
    bool givescheck = false;
    bool iscastle = false;
    bool givesmate = false;
    bool iscapture = false;
    bool ispromote = false;
    string prompiece;
    string sanmove;
    const string sanpiece =  ".PPNNBBRRQQKK";
    //cout<<"\n converting "<<printmove(move)<<" ";
    uint side = pboard.getside();
   // pboard.printboard();
   // mat.printmaterial();

   cMovelist mlist;

    gen_all_moves(pboard, mat, mlist, NULLMOVE);
    uint *list = mlist.p2list(pboard.getply());
    uint *list2 = NULL;
    bool found = false;
    uint i,j,played=0;

    //first loop, looking for move and if it gives check, or mate
    for( i = 0; i < mlist.getcount(pboard.getply()); ++i)
    {
           if (makemove(pboard,mat,his,list[i])) {takemove(pboard,mat,his);continue; }
       //    cout<<"\n\t\t\t "<<i<<" "<<printmove(list[i]);
     //      pboard.printboard();
           if(list[i] == move)
           {
               found = true;
    //           cout<<" could be... ";
               if(incheck(pboard,mat,pboard.getside()))
               {
                givescheck=true;
        //        cout<<" givescheck ";
                gen_all_moves(pboard, mat, mlist, NULLMOVE);
                list2 = mlist.p2list(pboard.getply());

                 for( j = 0; j < mlist.getcount(pboard.getply()); ++j)
                 {
                     // cout<<"\ntrying "<<printmove(list2[j]);
                      if (makemove(pboard,mat,his,list2[j]))
                      {
                        //  cout<< " notok ";
                          takemove(pboard,mat,his);
                          continue;
                      }
                   //   cout<< " ok! ";
                      played++;
                      takemove(pboard,mat,his);
                      break;
                 }
                 if(!played) { givesmate = true; givescheck=false;}
               }
           }
           takemove(pboard,mat,his);
           if(found==true) break;
    }

    if(found==false)
    {
         cout<<"\n MOVE NOT FOUND "<<printmove(move)<<" ";
         ASS(true==false);
         return " error san";
    }

     //second loop, looking for ambiguity
     for( i = 0; i < mlist.getcount(pboard.getply()); ++i)
     {
            if (makemove(pboard,mat,his,list[i])) {takemove(pboard,mat,his);continue; }
            takemove(pboard,mat,his);
            if(list[i] == move) continue;
            if(board[FROM(list[i])] == piecefrom && TO(list[i]) == to)
            {
                ambiguous = true;
                ambigsq[ambignum] = FROM(list[i]);
                ambignum++;
            }
     }

     //cout<<"\n loops finished, printing board ";
     //pboard.printboard();
     //now set the flag boolean values
     if(moveiscastle(side,pboard,move)) iscastle = true;
     if(moveiscapture(move)) iscapture = true;
     if(PROM(move))
     {
         ispromote = true;
         switch (PROM(move))
		   {
		    case pwN:prompiece = "N"; break;
		    case pwB:prompiece = "B"; break;
		    case pwR:prompiece = "R"; break;
		    case pwQ:prompiece = "Q"; break;
		    case pbN:prompiece = "N"; break;
		    case pbB:prompiece = "B"; break;
		    case pbR:prompiece = "R"; break;
		    case pbQ:prompiece = "Q"; break;
			default : cout<<" \n san prom problems";ASS(true==false);break;
		   }
     }

     //now deal with promotions, castling and pawn moves, and return them
    if(iscastle)
    {
       // cout<<" castle ";
        if(to == G8 || to == G1)
        { sanmove = "O-O"; }
        else { sanmove = "O-O-O"; }

        if(givescheck) sanmove+="+";
        else if(givesmate) sanmove+="#";

        return sanmove;
    }
    if(ispromote)
    {
       // cout<<" promote ";
        if(iscapture)
        {
         //   cout<<" cap ";
            sanmove+=filetostr[fromfile];
            sanmove+=ranktostr[fromrank];
            sanmove+="x";
        }
        sanmove+=filetostr[tofile];
        sanmove+=ranktostr[torank];
        sanmove+="=";
        sanmove+=prompiece;
        if(givescheck) sanmove+="+";
        else if(givesmate) sanmove+="#";

        return sanmove;
    }

    if(piecefrom==pwP || piecefrom==pbP)
    {
     //   cout<<" pawn ";
        if(iscapture)
        {
      //      cout<<" cap ";
            sanmove+=filetostr[fromfile];
            sanmove+="x";
        }
        sanmove+=filetostr[tofile];
        sanmove+=ranktostr[torank];
        if(givescheck) sanmove+="+";
        else if(givesmate) sanmove+="#";
        return sanmove;
    }

    if(!ambiguous)
    {
        //cout<<" not ambig ";
        sanmove+=sanpiece[piecefrom];
        if(iscapture) { /* cout<<" cap ";*/sanmove+="x"; }
        sanmove+=filetostr[tofile];
        sanmove+=ranktostr[torank];
        if(givescheck) sanmove+="+";
        else if(givesmate) sanmove+="#";
        return sanmove;
    }
    else
    {
        int usefile = 1;
        int userank = 1;
       // cout<<" ambig ";
        for(uint c = 0; c < ambignum; ++c)
        {
            if(files[ambigsq[c]]==fromfile) usefile = 0;
            if(ranks[ambigsq[c]]==fromrank) userank = 0;
        }
        sanmove+=sanpiece[piecefrom];
        if(usefile) sanmove+=filetostr[fromfile];
        else if(userank) sanmove+=ranktostr[fromrank];
        else
        {
                sanmove+=filetostr[fromfile];
                sanmove+=ranktostr[fromrank];
        }
        if(iscapture) { /* cout<<" cap ";*/sanmove+="x"; }
        sanmove+=filetostr[tofile];
        sanmove+=ranktostr[torank];
        if(givescheck) sanmove+="+";
        else if(givesmate) sanmove+="#";
        return sanmove;
    }
}

uint santomove(const string sanmove, cBoard &board, cMaterial &mat)
{

    uint length = sanmove.length();
    uint last = length-1;
    ASS(length>1&&length<8);

   // cout<<"\n move in "<<sanmove;


    bool capture = false;
    bool promote = false;
    bool fileambig = false;
    bool rankambig = false;
    bool found = false;


    string::size_type locater  = sanmove.find("x",0);
    if(locater != string::npos) capture = true;
    locater  = sanmove.find("=",0);
    if(locater != string::npos) promote = true;

//    if(capture) cout<<" capture "; else cout<<" not capture ";
 //   if(promote) cout<<" promote "; else cout<<" not promote ";

    uint piece=0;
    uint side = board.getside();
    uint ff,tf,fr,tr,from=0,to=0,cap=0,prom=0,flag=0,move;
    uint *brd = board.p2board();

    ASS(side>=cW&&side<=cB);

    if(sanmove == "0-0" || sanmove == "O-O")
    {
        cap = pE; flag = FlagCA;
        if(side==cW) { from = E1; to = G1;  }
        else { from = E8; to = G8;  }
    }
    else if(sanmove == "0-0-0" || sanmove == "O-O-O")
    {
        cap = pE; flag = FlagCA;
        if(side==cW) { from = E1; to = C1;  }
        else { from = E8; to = C8;  }
    }
    else if(sanmove[0] >= 'a')//pawn move?
    {
      //  cout<<" pawn move ";
        ASS(sanmove[0] >= 'a' && sanmove[0] <= 'h');
        if(side == cW)  piece = pwP;
        else piece = pbP;

        //if we don't have a capture, the first letter will be the file of the target square
        if(!capture) //e4 or e8=Q
        {
            ASS(sanmove[1] >= '1' && sanmove[1] <= '8');
            tf = chartofile(sanmove[0]);
            tr = chartorank(sanmove[1]);
            to = fr2sq(tf,tr);

            ASS(brd[to]==pE);
            ASS(onbrd(to));

            //could have been a 2 move start
            if(side==cW)
            {
              if(ranks[to]==RANK4)
              {
                if(brd[to+S]==pE) from=to+S+S;
                else from=to+S;
              }
              else
              {
                  from = to+S;
              }
            }
            else
            {
               if(ranks[to]==RANK5)
              {
                if(brd[to+N]==pE) from=to+N+N;
                else from=to+N;
              }
              else
              {
                  from = to+N;
              }
            }
        }//end of if !capture
        else //form will be exf4
        {
            //cout<<" pcap ";
            tf = chartofile(sanmove[2]);
            tr = chartorank(sanmove[3]);
            if(side==cW) fr = tr-1;
            else fr = tr+1;
            ff = chartofile(sanmove[0]);
            to = fr2sq(tf,tr);
           // cout<<"\n to = "<<printsquare(to);
            cap = brd[to];
           // cout<<" f "<<ff<<" r "<<fr;
            from = fr2sq(ff,fr);
           // cout<<" ? "<<printsquare(to);
            ASS(onbrd(from));
            ASS(onbrd(to));
            ASS( (cap==pE && flag==FlagEP) || piecegood(cap) );

            if(brd[to]==pE) flag=FlagEP; //ep cap
        }
    }
    else//not pawn move
    {
        //identify the moving piece
        switch(sanmove[0])
        {
            case 'K': if (side==cW) piece=pwK;else piece=pbK; break;
            case 'Q': if (side==cW) piece=pwQ;else piece=pbQ; break;
            case 'R': if (side==cW) piece=pwR;else piece=pbR; break;
            case 'B': if (side==cW) piece=pwB;else piece=pbB; break;
            case 'N': if (side==cW) piece=pwN;else piece=pbN; break;
            default: cout<<"\n piece unidentified";
        }

        ASS(piecegood(piece));
    //    cout<<" piece move "<<piecechar(piece)<<" ";

        //idendtify ambiguity
        if(sanmove[1] >='1' && sanmove[1] <= '8')
        {
            rankambig=true;
        //    cout<<" rankambig ";
        }
        else
        {
             if(capture)
             {
                 if(sanmove[1] >='a' && sanmove[1] <= 'h')
                 {
                     fileambig=true;
                  //   cout<<" fileambig ";
                 }
             }
             else
             {
                 if((sanmove[1] >='a' && sanmove[1] <= 'h') && (sanmove[2] >='a' && sanmove[2] <= 'h') )
                 {
                     fileambig=true;
                  //   cout<<" fileambig ";
                 }
             }
        }

        //now identify the to sq
        if(!capture)
        {
            if(!rankambig && !fileambig)
            {
                tf = chartofile(sanmove[1]);
                tr = chartorank(sanmove[2]);
                to = fr2sq(tf,tr);
                ASS(onbrd(to));
                ASS(brd[to]==pE);
            }
            else
            {
                tf = chartofile(sanmove[2]);
                tr = chartorank(sanmove[3]);
                to = fr2sq(tf,tr);
                ASS(onbrd(to));
                ASS(brd[to]==pE);
            }
        }
        else//is capture
        {
            if(!rankambig && !fileambig) //Nxd4
            {
                tf = chartofile(sanmove[2]);
                tr = chartorank(sanmove[3]);
                to = fr2sq(tf,tr);
                cap = brd[to];
                ASS(onbrd(to));
                ASS(brd[to]!=pE);
            }
            else //Nexd4
            {
                tf = chartofile(sanmove[3]);
                tr = chartorank(sanmove[4]);
                to = fr2sq(tf,tr);
                cap = brd[to];
                ASS(onbrd(to));
                ASS(brd[to]!=pE);
            }
        }

        uint ar;
        uint af;
        uint i,pcenum,sq,tsq;
        const int *movedir;
        //now need the from sqaure, start with ambig, it's easier, just look for the piece on relevant file or rank
        if(rankambig)
        {
            ar = chartorank(sanmove[1]);
            ASS(ranks[N*ar]==ar);
            for(i = N*ar; !(i&0x88); i+=E)
            {
                if(brd[i]==piece) { from=i; break; }
            }
        }
        else if(fileambig)
        {
            af = chartofile(sanmove[1]);
           // cout<<" ambigfile = "<<af;
            for(i = af; !(i&0x88); i+=N)
            {
              //  cout<<" trying "<<printsquare(i);
                if(brd[i]==piece) {
                    // cout<<"\n found "<<piecechar(brd[i]);
                     from=i; break; }
            }
        }
        else//not ambig, need to find the piece using the to square and the known piece type
        {
            pcenum = mat.getpcenum(piece);
            while(pcenum)
            {
                sq = mat.getpcesq(piece, pcenum);
              //  cout<<" onsq "<<printsquare(sq);
                ASS(onbrd(sq));
                for(movedir = dirPieces[piece]; *movedir ; movedir++)
                {
                    if(isslide[piece])
                    {
                     for(tsq = sq+*movedir; !(tsq & 0x88); tsq += *movedir)
                     {
                        // cout<<" to tsq "<<printsquare(tsq);
                        if(tsq==to) {from=sq; found = true; break;}
                        if(brd[tsq]!=pE) break;
                     }
                    }
                    else
                    {
                        if(sq+*movedir==to) {from=sq; found = true; break;}
                    }
                }
                if(found) break;
                pcenum--;
            }
        }
    }


    if(promote)
    {
        ASS(ranks[to]==RANK1 || ranks[to]==RANK8);
        if(sanmove[last]=='#' || sanmove[last]=='+') last--;
     switch (sanmove[last])
     {
      case 'Q': if(side==cW) prom = pwQ; else prom = pbQ; break;
      case 'R': if(side==cW) prom = pwR; else prom = pbR; break;
      case 'B': if(side==cW) prom = pwB; else prom = pbB; break;
      case 'N': if(side==cW) prom = pwN; else prom = pbN; break;
      default: cout<<"\n sanmove prom piece not found";ASS(true==false);break;
      }
    }

           move = (from | (to<<7) | (cap<<16) | (prom<<20) | flag);

         //  cout<<"\n move is "<<printmove(move)<<" "<<move;
         //  cout<<" from "<<FROM(move)<<" to "<<TO(move)<<" flag "<<FLAG(move)<<" cap "<<CAP(move);

#ifdef DEBUG
    cMovelist mlist;
    gen_all_moves(board, mat, mlist, NULLMOVE);
    uint *list = mlist.p2list(board.getply());
    found = false;
    uint i;

    //first loop, looking for move and if it gives check, or mate
    for( i = 0; i < mlist.getcount(board.getply()); ++i)
    {
         //  cout<<"\n\t checking "<<printmove(list[i])<<" "<<list[i];
         //  cout<<" from "<<FROM(list[i])<<" to "<<TO(list[i])<<" flag "<<FLAG(list[i])<<" cap "<<CAP(list[i]);
           if(list[i] == move)
           found=true;
    }
    ASS(found);
#endif

return move;
}
